// Generated by CoffeeScript 1.9.0
var ISOLATION_LEVEL, OPERATION_TYPE, Transaction, WritableTrackingBuffer, isolationLevelByValue, name, value, writeAllHeaders;

WritableTrackingBuffer = require('./tracking-buffer/writable-tracking-buffer');

writeAllHeaders = require('./all-headers').writeToTrackingBuffer;


/*
  s2.2.6.8
 */

OPERATION_TYPE = {
  TM_GET_DTC_ADDRESS: 0x00,
  TM_PROPAGATE_XACT: 0x01,
  TM_BEGIN_XACT: 0x05,
  TM_PROMOTE_XACT: 0x06,
  TM_COMMIT_XACT: 0x07,
  TM_ROLLBACK_XACT: 0x08,
  TM_SAVE_XACT: 0x09
};

ISOLATION_LEVEL = {
  NO_CHANGE: 0x00,
  READ_UNCOMMITTED: 0x01,
  READ_COMMITTED: 0x02,
  REPEATABLE_READ: 0x03,
  SERIALIZABLE: 0x04,
  SNAPSHOT: 0x05
};

isolationLevelByValue = {};

for (name in ISOLATION_LEVEL) {
  value = ISOLATION_LEVEL[name];
  isolationLevelByValue[value] = name;
}

Transaction = (function() {
  function Transaction(_at_name, _at_isolationLevel) {
    this.name = _at_name;
    this.isolationLevel = _at_isolationLevel;
    this.outstandingRequestCount = 1;
  }

  Transaction.prototype.beginPayload = function(txnDescriptor) {
    var buffer, payload;
    buffer = new WritableTrackingBuffer(100, 'ucs2');
    writeAllHeaders(buffer, txnDescriptor, this.outstandingRequestCount);
    buffer.writeUShort(OPERATION_TYPE.TM_BEGIN_XACT);
    buffer.writeUInt8(this.isolationLevel);
    buffer.writeUInt8(this.name.length * 2);
    buffer.writeString(this.name, 'ucs2');
    return payload = {
      data: buffer.data,
      toString: (function(_this) {
        return function() {
          return "Begin Transaction: name=" + _this.name + ", isolationLevel=" + isolationLevelByValue[_this.isolationLevel];
        };
      })(this)
    };
  };

  Transaction.prototype.commitPayload = function(txnDescriptor) {
    var buffer, payload;
    buffer = new WritableTrackingBuffer(100, 'ascii');
    writeAllHeaders(buffer, txnDescriptor, this.outstandingRequestCount);
    buffer.writeUShort(OPERATION_TYPE.TM_COMMIT_XACT);
    buffer.writeUInt8(this.name.length * 2);
    buffer.writeString(this.name, 'ucs2');
    buffer.writeUInt8(0);
    return payload = {
      data: buffer.data,
      toString: (function(_this) {
        return function() {
          return "Commit Transaction: name=" + _this.name;
        };
      })(this)
    };
  };

  Transaction.prototype.rollbackPayload = function(txnDescriptor) {
    var buffer, payload;
    buffer = new WritableTrackingBuffer(100, 'ascii');
    writeAllHeaders(buffer, txnDescriptor, this.outstandingRequestCount);
    buffer.writeUShort(OPERATION_TYPE.TM_ROLLBACK_XACT);
    buffer.writeUInt8(this.name.length * 2);
    buffer.writeString(this.name, 'ucs2');
    buffer.writeUInt8(0);
    return payload = {
      data: buffer.data,
      toString: (function(_this) {
        return function() {
          return "Rollback Transaction: name=" + _this.name;
        };
      })(this)
    };
  };

  Transaction.prototype.savePayload = function(txnDescriptor) {
    var buffer, payload;
    buffer = new WritableTrackingBuffer(100, 'ascii');
    writeAllHeaders(buffer, txnDescriptor, this.outstandingRequestCount);
    buffer.writeUShort(OPERATION_TYPE.TM_SAVE_XACT);
    buffer.writeUInt8(this.name.length * 2);
    buffer.writeString(this.name, 'ucs2');
    return payload = {
      data: buffer.data,
      toString: (function(_this) {
        return function() {
          return "Save Transaction: name=" + _this.name;
        };
      })(this)
    };
  };

  Transaction.prototype.isolationLevelToTSQL = function() {
    switch (this.isolationLevel) {
      case ISOLATION_LEVEL.READ_UNCOMMITTED:
        return 'READ UNCOMMITTED';
      case ISOLATION_LEVEL.READ_COMMITTED:
        return 'READ COMMITTED';
      case ISOLATION_LEVEL.REPEATABLE_READ:
        return 'REPEATABLE READ';
      case ISOLATION_LEVEL.SERIALIZABLE:
        return 'SERIALIZABLE';
      case ISOLATION_LEVEL.SNAPSHOT:
        return 'SNAPSHOT';
    }
    return '';
  };

  return Transaction;

})();

exports.Transaction = Transaction;

exports.ISOLATION_LEVEL = ISOLATION_LEVEL;
