// Generated by CoffeeScript 1.9.0
var convertLEBytesToString, getNextRemainder, invert, isZero, numberToInt64LE;

isZero = function(array) {
  var byte, _i, _len;
  for (_i = 0, _len = array.length; _i < _len; _i++) {
    byte = array[_i];
    if (byte !== 0) {
      return false;
    }
  }
  return true;
};

getNextRemainder = function(array) {
  var index, remainder, s, _i, _ref;
  remainder = 0;
  for (index = _i = _ref = array.length - 1; _i >= 0; index = _i += -1) {
    s = (remainder * 256) + array[index];
    array[index] = Math.floor(s / 10);
    remainder = s % 10;
  }
  return remainder;
};

invert = function(array) {
  var byte, index, _i, _j, _len, _len1, _results;
  for (index = _i = 0, _len = array.length; _i < _len; index = ++_i) {
    byte = array[index];
    array[index] = array[index] ^ 0xFF;
  }
  _results = [];
  for (index = _j = 0, _len1 = array.length; _j < _len1; index = ++_j) {
    byte = array[index];
    array[index] = array[index] + 1;
    if (array[index] > 255) {
      _results.push(array[index] = 0);
    } else {
      break;
    }
  }
  return _results;
};

convertLEBytesToString = function(buffer) {
  var array, result, sign, t;
  array = Array.prototype.slice.call(buffer, 0, buffer.length);
  if (isZero(array)) {
    return '0';
  } else {
    if (array[array.length - 1] & 0x80) {
      sign = '-';
      invert(array);
    } else {
      sign = '';
    }
    result = '';
    while (!isZero(array)) {
      t = getNextRemainder(array);
      result = t + result;
    }
    return sign + result;
  }
};

numberToInt64LE = function(num) {
  var buf, carry, hi, i, lo, negate, v, _i, _j;
  negate = num < 0;
  hi = Math.abs(num);
  lo = hi % 0x100000000;
  hi = (hi / 0x100000000) | 0;
  buf = new Buffer(8);
  for (i = _i = 0; _i <= 7; i = ++_i) {
    buf[i] = lo & 0xff;
    lo = i === 3 ? hi : lo >>> 8;
  }
  if (negate) {
    carry = 1;
    for (i = _j = 0; _j <= 7; i = ++_j) {
      v = (buf[i] ^ 0xff) + carry;
      buf[i] = v & 0xff;
      carry = v >> 8;
    }
  }
  return buf;
};

module.exports.convertLEBytesToString = convertLEBytesToString;

module.exports.numberToInt64LE = numberToInt64LE;
