// Generated by CoffeeScript 1.9.0
var parser, sprintf, valueParse;

valueParse = require('../value-parser');

sprintf = require('sprintf').sprintf;

parser = function(buffer, columnsMetaData, options) {
  var bitmap, byte, bytes, column, columnMetaData, columns, i, index, length, value, _i, _j, _k, _len, _len1;
  length = Math.ceil(columnsMetaData.length / 8);
  bytes = buffer.readBuffer(length);
  bitmap = [];
  for (_i = 0, _len = bytes.length; _i < _len; _i++) {
    byte = bytes[_i];
    for (i = _j = 0; _j <= 7; i = ++_j) {
      bitmap.push(byte & (1 << i) ? true : false);
    }
  }
  columns = options.useColumnNames ? {} : [];
  for (index = _k = 0, _len1 = columnsMetaData.length; _k < _len1; index = ++_k) {
    columnMetaData = columnsMetaData[index];
    if (bitmap[index]) {
      value = null;
    } else {
      value = valueParse(buffer, columnMetaData, options);
    }
    column = {
      value: value,
      metadata: columnMetaData
    };
    if (options.useColumnNames) {
      if (columns[columnMetaData.colName] == null) {
        columns[columnMetaData.colName] = column;
      }
    } else {
      columns.push(column);
    }
  }
  return {
    name: 'NBCROW',
    event: 'row',
    columns: columns
  };
};

module.exports = parser;
