// Generated by CoffeeScript 1.9.0
var STATUS, doneInProcParser, doneParser, doneProcParser, parser, versions;

versions = require('../tds-versions').versionsByValue;

STATUS = {
  MORE: 0x0001,
  ERROR: 0x0002,
  INXACT: 0x0004,
  COUNT: 0x0010,
  ATTN: 0x0020,
  SRVERROR: 0x0100
};

parser = function(buffer, options) {
  var attention, curCmd, inTxn, more, rowCount, rowCountValid, serverError, sqlError, status, token;
  status = buffer.readUInt16LE();
  more = !!(status & STATUS.MORE);
  sqlError = !!(status & STATUS.ERROR);
  inTxn = !!(status & STATUS.INXACT);
  rowCountValid = !!(status & STATUS.COUNT);
  attention = !!(status & STATUS.ATTN);
  serverError = !!(status & STATUS.SRVERROR);
  curCmd = buffer.readUInt16LE();
  if (options.tdsVersion < "7_2") {
    rowCount = buffer.readUInt32LE();
  } else {
    rowCount = buffer.readUInt64LE();
  }
  if (!rowCountValid) {
    rowCount = void 0;
  }
  return token = {
    name: 'DONE',
    event: 'done',
    more: more,
    sqlError: sqlError,
    attention: attention,
    serverError: serverError,
    rowCount: rowCount,
    curCmd: curCmd
  };
};

doneParser = function(buffer, colMetadata, options) {
  var token;
  token = parser(buffer, options);
  token.name = 'DONE';
  token.event = 'done';
  return token;
};

doneInProcParser = function(buffer, colMetadata, options) {
  var token;
  token = parser(buffer, options);
  token.name = 'DONEINPROC';
  token.event = 'doneInProc';
  return token;
};

doneProcParser = function(buffer, colMetadata, options) {
  var token;
  token = parser(buffer, options);
  token.name = 'DONEPROC';
  token.event = 'doneProc';
  return token;
};

exports.doneParser = doneParser;

exports.doneInProcParser = doneInProcParser;

exports.doneProcParser = doneProcParser;
