// Generated by CoffeeScript 1.9.0
var Debug, EventEmitter, util,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  __hasProp = {}.hasOwnProperty;

EventEmitter = require('events').EventEmitter;

util = require('util');

Debug = (function(_super) {
  __extends(Debug, _super);


  /*
    @options    Which debug details should be sent.
                  data    - dump of packet data
                  payload - details of decoded payload
   */

  function Debug(_at_options) {
    this.options = _at_options;
    this.options = this.options || {};
    this.options.data = this.options.data || false;
    this.options.payload = this.options.payload || false;
    this.options.packet = this.options.packet || false;
    this.options.token = this.options.token || false;
    this.indent = '  ';
  }

  Debug.prototype.packet = function(direction, packet) {
    if (this.haveListeners() && this.options.packet) {
      this.log('');
      this.log(direction);
      return this.log(packet.headerToString(this.indent));
    }
  };

  Debug.prototype.data = function(packet) {
    if (this.haveListeners() && this.options.data) {
      return this.log(packet.dataToString(this.indent));
    }
  };

  Debug.prototype.payload = function(generatePayloadText) {
    if (this.haveListeners() && this.options.payload) {
      return this.log(generatePayloadText());
    }
  };

  Debug.prototype.token = function(token) {
    if (this.haveListeners() && this.options.token) {
      return this.log(util.inspect(token, false, 5, true));
    }
  };

  Debug.prototype.haveListeners = function() {
    return this.listeners('debug').length > 0;
  };

  Debug.prototype.log = function(text) {
    return this.emit('debug', text);
  };

  return Debug;

})(EventEmitter);

module.exports = Debug;
