var https = require('http');
var querystring = require('querystring');
var Sequelize = require('sequelize');
var Promise = Sequelize.Promise;
var config = require('./config');
var iconv = require('iconv-lite');

module.exports.send= (mobile, message) =>{
    return new Promise((resolve) => {
        var postData = {
            un: config.SysConfig.CorpID,
            pw: config.SysConfig.Pwd,
            da: mobile,
            sm: message,
            dc: 15, //中文gbk
            tf: 3,
            rf: 2, //返回json
        };
        var content = querystring.stringify(postData);
        var options = {
            host: config.SysConfig.apiHost,
            path: config.SysConfig.apiPath,
            port : config.SysConfig.apiPort,
            method: 'POST',
            agent: false,
            rejectUnauthorized : false,
            headers:{
                'Content-Type' : 'application/x-www-form-urlencoded',
                'Content-Length' : content.length
            }
        };
        var req = https.request(options,(res) => {
            res.setEncoding('utf8');
            res.on('data', (chunk) => {
                const data = JSON.parse(chunk)
                if(data.id) {
                    resolve({ flag: 0 });
                } else {
                    resolve({ flag: -1, note: data.r});
                }
            });
        });
        req.on('error',(err) => {
            resolve({flag: -1, msg: err.message})
        });
        req.write(content);
        req.end();
    });
};
