var Sequelize = require('sequelize')
var Promise = Sequelize.Promise
var DbConfig = require('./config').DbConfig
var msg = require('./message')
Date.prototype.format = function (format) {
  var date = {
    'M+': this.getMonth() + 1,
    'd+': this.getDate(),
    'h+': this.getHours(),
    'm+': this.getMinutes(),
    's+': this.getSeconds(),
    'q+': Math.floor((this.getMonth() + 3) / 3),
    'S+': this.getMilliseconds()
  }

  if (new RegExp('(y+)', 'i').test(format)) {
    format = format.replace(RegExp.$1, (this.getFullYear() + '').substr(4 - RegExp.$1.length))
  }

  for (var k in date) {
    if (new RegExp('(' + k + ')').test(format)) {
      format = format.replace(RegExp.$1, RegExp.$1.length == 1
        ? date[k] : ('00' + date[k]).substr(('' + date[k]).length))
    }
  }

  return format
}
function getNow () {
  return (new Date()).format('yyyy-MM-dd hh:mm:ss')
}
function getSequelize (config) {
  return new Sequelize(config.database,
    config.user,
    config.password,
    {
      host: config.host,
      port: config.port,
      dialect: config.dialect,
      pool: config.pool,
      logging: false
    })
} /* getSequelize */

var mssql = getSequelize(DbConfig)
function start () {
  //console.log((new Date()).format('yyyy-MM-dd hh:mm:ss')+' start')
  var sql = 'select top 10 MM_ID,MM_MobileNo,MM_Msg from mobileMsgs where MM_IfSended=0 and getdate()>=MM_DateTime' +
    ' and (mm_SendBeginTime is  null  or (mm_SendBeginTime is not null and  (datepart(hh,getdate()) BETWEEN mm_SendBeginTime and mm_SendEndTime)))'
  if (DbConfig.dialect === 'mysql')
    sql = 'select  MM_ID,MM_MobileNo,MM_Msg from mobileMsgs where MM_IfSended=0 and MM_DateTime < "NOW()"'
      + ' and (mm_SendBeginTime is  null  or (mm_SendBeginTime is not null and  hour(now()) BETWEEN mm_SendBeginTime and mm_SendEndTime)) limit 10'
      // console.log(sql)

  mssql
    .query(sql)
    .spread(function (rows) {
      // console.log(rows)
      return rows;})
    .each(function (row) {
      // console.log(row)
      return msg.send(row.MM_MobileNo, row.MM_Msg).then(function (result) {
        console.log(result)
        if (result.flag >= 0) {
          console.log('%s send to %s sucess.\r\n', getNow(), row.MM_MobileNo)
        } else
          console.log('%s send to %s fail。return ：%s, error :%s\r\n', getNow(), row.MM_MobileNo, result.flag, result.note)
        if (DbConfig.dialect === 'mysql')
          mssql.query('update mobileMsgs set MM_IfSended=1,MM_SendDateTime=NOW() where MM_ID=' + row.MM_ID)
        else
          mssql.query('update mobileMsgs set MM_IfSended=1,MM_SendDateTime=getdate() where MM_ID=' + row.MM_ID)
        return result
      })
    })
    .catch(function (err) {
      console.log('%s error :%s\r\n', getNow(), err.message)
    })
    .finally(function () {
      // console.log('*********' + new Date())
      setTimeout(function () {
        start()
      }, 1000 * 3)
    })
}
function updateOldMsg () {
  var sql = 'update  mobileMsgs set MM_IfSended=2 where MM_IfSended=0 and getdate()>=MM_DateTime' +
    ' and (mm_SendBeginTime is  null  or (mm_SendBeginTime is not null and  (datepart(hh,getdate()) BETWEEN mm_SendBeginTime and mm_SendEndTime)))'
  if (DbConfig.dialect === 'mysql')
    sql = 'update  mobileMsgs set MM_IfSended=2 where MM_IfSended=0 and now()>=MM_DateTime '
      + ' and (mm_SendBeginTime is  null  or (mm_SendBeginTime is not null and  (hour(now()) BETWEEN mm_SendBeginTime and mm_SendEndTime)))'
  mssql
    .query(sql)
}
updateOldMsg()
start()
